package data.missions.duelofthecentury;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.dark.shaders.post.PostProcessShader;
import org.lwjgl.util.vector.Vector3f;

public class MissionDefinition implements MissionDefinitionPlugin {

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "FOF", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "ISS", FleetGoal.ATTACK, true);

        api.setFleetTagline(FleetSide.PLAYER, "Stolen Fabrique Orbitale prototype");
        api.setFleetTagline(FleetSide.ENEMY, "\"The Protectors\" elite bounty hunting group");

        api.setHyperspaceMode(true);

        api.addBriefingItem("Defeat \"The Protectors\".");
        api.addBriefingItem(
                "Captain Clawfoot's skills are impeccable; the Excelsior is particularly effective in battle.");
        api.addBriefingItem("Flux will increase slowly over time due to heat from the nearby star.");

        PersonAPI captain = api.addToFleet(FleetSide.PLAYER, "ssp_excelsior_cap", FleetMemberType.SHIP, "FOF Excelsior",
                                           true).getCaptain();
        captain.getStats().setAptitudeLevel("combat", 3);
        captain.getStats().setAptitudeLevel("technology", 3);
        captain.getStats().setSkillLevel("combat_endurance", 3);
        captain.getStats().setSkillLevel("missile_specialization", 3);
        captain.getStats().setSkillLevel("ordnance_expert", 3);
        captain.getStats().setSkillLevel("target_analysis", 3);
        captain.getStats().setSkillLevel("damage_control", 3);
        captain.getStats().setSkillLevel("impact_mitigation", 3);
        captain.getStats().setSkillLevel("defensive_systems", 3);
        captain.getStats().setSkillLevel("advanced_countermeasures", 3);
        captain.getStats().setSkillLevel("evasive_action", 3);
        captain.getStats().setSkillLevel("helmsmanship", 3);
        captain.getStats().setSkillLevel("gunnery_implants", 3);
        captain.getStats().setSkillLevel("flux_modulation", 3);

        api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Mozart", true);
        if (SWPModPlugin.hasUnderworld) {
            api.addToFleet(FleetSide.ENEMY, "ssp_venomx_sta", FleetMemberType.SHIP, "ISS Beethoven", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Beethoven", false);
        }
        if (SWPModPlugin.blackrockExists) {
            api.addToFleet(FleetSide.ENEMY, "brdy_imaginos_shock", FleetMemberType.SHIP, "ISS Vivaldi", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Vivaldi", false);
        }
        if (SWPModPlugin.exigencyExists) {
            api.addToFleet(FleetSide.ENEMY, "exigency_indra_Standard", FleetMemberType.SHIP, "ISS Tartini", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Tartini", false);
        }
		/*
        if (SWPModPlugin.citadelExists) {
            api.addToFleet(FleetSide.ENEMY, "Fox_Strike_strike", FleetMemberType.SHIP, "ISS Bach", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Bach", false);
        }
		*/
		if (SWPModPlugin.shadowyardsExists) {
            api.addToFleet(FleetSide.ENEMY, "ms_shamash_EMP", FleetMemberType.SHIP, "ISS Mendelssohn", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Mendelssohn", false);
        }
        if (SWPModPlugin.templarsExists) {
            api.addToFleet(FleetSide.ENEMY, "tem_jesuit_est", FleetMemberType.SHIP, "ISS Paganini", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Paganini", false);
        }
        if (SWPModPlugin.imperiumExists) {
            api.addToFleet(FleetSide.ENEMY, "ii_maximus_str", FleetMemberType.SHIP, "ISS Dvorak", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Dvorak", false);
        }
        if (SWPModPlugin.scyExists) {
            api.addToFleet(FleetSide.ENEMY, "SCY_stymphalianbird_combat", FleetMemberType.SHIP, "ISS Saint-Saens", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Saint-Saens", false);
        }
        if (SWPModPlugin.diableExists) {
            api.addToFleet(FleetSide.ENEMY, "diableavionics_versant_standard", FleetMemberType.SHIP, "ISS Haydn", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Haydn", false);
        }

        float width = 10000f;
        float height = 10000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        api.addAsteroidField(0f, 0f, (float) Math.random() * 360f, width, 30f, 200f, 500);
        api.addPlugin(new Plugin());
    }

    private final static class Plugin extends BaseEveryFrameCombatPlugin {

        private boolean reallyStarted = false;
        private boolean started = false;

        @Override
        public void advance(float amount, List<InputEventAPI> events) {
            if (!started) {
                started = true;
                return;
            }
            if (!reallyStarted) {
                reallyStarted = true;

                StandardLight sun = new StandardLight();
                sun.setType(3);
                sun.setDirection((Vector3f) (new Vector3f(-1f, -1f, -0.2f)).normalise());
                sun.setIntensity(0f);
                sun.setSpecularIntensity(2f);
                sun.setColor(new Color(212, 91, 22));
                sun.makePermanent();
                LightShader.addLight(sun);

                sun = new StandardLight();
                sun.setType(3);
                sun.setDirection((Vector3f) (new Vector3f(0f, 0f, -1f)).normalise());
                sun.setIntensity(0.75f);
                sun.setSpecularIntensity(0f);
                sun.setColor(new Color(212, 91, 22));
                sun.makePermanent();
                LightShader.addLight(sun);

                PostProcessShader.setSaturation(false, 1.1f);
                PostProcessShader.setLightness(false, 1.1f);
                PostProcessShader.setContrast(false, 1.1f);
                PostProcessShader.setNoise(false, 0.1f);
            }

            if (Global.getCombatEngine().isPaused()) {
                return;
            }

            for (ShipAPI ship : Global.getCombatEngine().getShips()) {
                if (ship.getHullSpec().getHullId().contentEquals("ssp_excelsior")) {
                    ship.getFluxTracker().increaseFlux(100f * amount, true);
                }
            }
        }

        @Override
        public void init(CombatEngineAPI engine) {
        }
    };
}
